using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public class ChipManager : MonoBehaviour
{
    public static ChipManager instance;
    [SerializeField] FadeScene FadeSceneScript;
    [SerializeField] string NextSceneName;
    [SerializeField] int NextSceneLevel;
    [SerializeField] int ChipCounter;
    [SerializeField] int MaxChipInGame;
    public void AddChip()
    {
        ChipCounter++;
        if (ChipCounter >= MaxChipInGame)
        {
            FadeSceneScript.SetLevel(NextSceneLevel);
            FadeSceneScript.MakeThing(NextSceneName);

        }
    }
    private void Awake()
    {
        if (instance == null)
            instance = this;
        else Destroy(this);
    }
}
